clear all

* Set Folder to output one

cd ..\Outputs

*===============================================================================
*		              Serial correlation in  revisions
*===============================================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*							          CBO
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use Data_CBO, clear

gen     semester=1 if quarter==1 | quarter==2
replace semester=2 if quarter==3 | quarter==4
drop quarter

gen time=year+(semester-1)/2
gen t=_n
tsset t

gen D911=(year==2001 & semester==2)
gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)

gen Y=CBOrevRpot1
gen X=l.CBOrevRpot1
ivregress 2sls Y X, vce(hac nw 4)
outreg2 X using correlationrevisions.dta, replace dec(3) nocons  ctitle("CBO")

ivregress 2sls Y X D911 DGR, vce(hac nw 4)
outreg2 X D911 DGR using correlationrevisions.dta, append dec(3) nocons ctitle("CBO")

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*							       Greenbook
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t

gen Y=GRErevRpot1
gen X=l.GRErevRpot1

* Dummy variable for the Great Recession

gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)

ivregress 2sls Y X, vce(hac nw 4)
outreg2 X using correlationrevisions.dta, append dec(3) nocons  ctitle("FED")

ivregress 2sls Y X DGR D911, vce(hac nw 4)
outreg2 X D911 DGR using correlationrevisions.dta, append dec(3) nocons ctitle("FED")

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*							          OECD
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

cd ..\..\International\Outputs
use SEMESTER, clear
cd ..\..\USA\Outputs

winsor REVOECD1, p(0.02) gen(REVOECD1w)
gen Y=REVOECD1w
gen X=l.REVOECD1w

xi: xtscc Y X i.tt, fe lag(4)

outreg2 X using correlationrevisions.dta, append dec(3) nocons  ctitle("OECD")

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*							          IMF
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

winsor SC, p(0.02) gen(SCw)
capture drop Y X
gen Y=SCw
gen X=l.SCw

xi: xtscc Y X i.tt, fe lag(4)

outreg2 X using correlationrevisions.dta, append dec(3) nocons  ctitle("IMF")

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*         Consensus Economics: revision in the 6-10 year ahead forecast
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

winsor REVI3CGDP, p(0.02) gen(REVI3CGDPw)
capture drop Y X
gen Y=REVI3CGDPw
gen X=l.REVI3CGDPw

xi: xtscc Y X i.tt, fe lag(4)

outreg2 X using correlationrevisions.dta, append dec(3) nocons  ctitle("CE")
